/*
 * Decompiled with CFR 0.152.
 */
package com.prs.DownloadManager;

import com.prs.DownloadManager.Constants;
import com.prs.DownloadManager.DownloadManager;
import com.prs.DownloadManager.SSL;
import com.prs.DownloadManager.Util;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;

public class Connection {
    private Constants constants;
    private Util util;
    public DownloadManager app;

    public Connection(DownloadManager app) {
        this.app = app;
        this.util = new Util();
        this.constants = new Constants();
    }

    public HttpURLConnection getConnection(String url_string) {
        try {
            return this.getConnection(new URL(url_string));
        }
        catch (Exception e) {
            this.util.writeToFile("info.log", "Error in Connection.getConnection(): " + e.getMessage(), true);
            return null;
        }
    }

    public HttpURLConnection getConnection(URL url) {
        try {
            HttpURLConnection con;
            if (url.getProtocol().equalsIgnoreCase("https")) {
                SSL ssl = new SSL();
                if (!ssl.validateCertificate()) {
                    throw new Exception(this.constants.ERROR_SECURE_CONNECTION);
                }
                HttpsURLConnection.setDefaultSSLSocketFactory(ssl.getSSLSocketFactory());
                con = (HttpsURLConnection)url.openConnection();
            } else {
                con = (HttpURLConnection)url.openConnection();
            }
            con.setRequestProperty("USER-AGENT", this.constants.APP_USER_AGENT);
            return con;
        }
        catch (Exception e) {
            this.util.writeToFile("info.log", "Error in Connection.getConnection(): " + e.getMessage(), true);
            return null;
        }
    }

    public void setSystemProxy(URL url) {
        try {
            System.setProperty("java.net.useSystemProxies", "true");
            List<Proxy> l = ProxySelector.getDefault().select(new URI("http://www.google.com"));
            for (Proxy proxy : l) {
                this.util.writeToFile("util.log", "proxy hostname: " + (Object)((Object)proxy.type()), true);
                InetSocketAddress addr = (InetSocketAddress)proxy.address();
                if (addr == null || addr.getHostName() == null || addr.getHostName().isEmpty()) {
                    this.util.writeToFile("util.log", "no proxy", true);
                    System.setProperty("java.net.useSystemProxies", "false");
                    continue;
                }
                this.util.writeToFile("util.log", "proxy hostname: " + addr.getHostName(), true);
                this.util.writeToFile("util.log", "proxy port: " + addr.getPort(), true);
            }
        }
        catch (Exception e) {
            this.util.writeToFile("proxy.log", "Error in Connection.setSystemProxy(): " + e.getMessage(), true);
        }
    }
}

