/*
 * Decompiled with CFR 0.152.
 */
package com.prs.DownloadManager;

import com.prs.DownloadManager.Preferences;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;

public class Constants {
    public String APP_TITLE = "Classical Archives Download Manager";
    public String APP_VERSION = "1.5";
    public String APP_USER_AGENT = "CMA Download Manager " + this.APP_VERSION;
    public String APP_COPYRIGHT = "Copyright 2010-2018, Classical Archives, LLC. All Rights Reserved.";
    public String APP_TITLE_ICON = "favicon.gif";
    public String APP_DOWNLOADS_LABEL = "Downloads Queue";
    public String APP_STATUS_LABEL = "Status";
    private Preferences prefs = new Preferences();
    public static final String[] STATUSES = new String[]{"Downloading", "Queued", "Completed", "Cancelled", "Error", "Verifying", "Moving"};
    public final int STATUS_DOWNLOADING = 0;
    public final int STATUS_PAUSED = 1;
    public final int STATUS_COMPLETED = 2;
    public final int STATUS_CANCELLED = 3;
    public final int STATUS_ERROR = 4;
    public final int STATUS_VERIFYING = 5;
    public final int STATUS_MOVING = 6;
    public Color APP_BACKGROUND = null;
    public String BUTTON_CHOOSE_DOWNLOADS_FOLDER = "Choose download folder...";
    public String BUTTON_DOWNLOAD_START = "START DOWNLOADING";
    public String BUTTON_DOWNLOAD_RESUME = "RESUME DOWNLOADING";
    public String BUTTON_DOWNLOAD_PAUSE = "PAUSE DOWNLOADING";
    public String BUTTON_DOWNLOAD_COMPLETE = "DOWNLOADING COMPLETE";
    public String MSG_LOGIN = "Please enter your Classical Archives login email and password, to retrieve your downloads.";
    public String MSG_DOWNLOAD_LOCATION = "";
    public String MSG_DOWNLOADING_COMPLETE = "<b>Downloading has finished.</b>";
    public String MSG_ADD_TO_YOUR_PLAYER_BEFORE_DOWNLOADING_HAS_FINISHED = "After your downloads have completed, we can add them to iTunes<sup>TM</sup> or Windows Media Player<sup>TM</sup>.";
    public String MSG_ADD_TO_YOUR_PLAYER_AFTER_DOWNLOADING_HAS_FINISHED = "We can add these downloads to iTunes<sup>TM</sup> or Windows Media Player<sup>TM</sup>.";
    public String MSG_ABOUT_DOWNLOADS_ON_YOUR_COMPUTER = "<font color=\"#ea0000\">Adding music to your player does <u>not</u> move the files to the player; it only creates links to the files in your destination folder.<br><br>If you delete your destination folder, you will lose your music files.</font>";
    public String CHOOSE_PROMPT_TITLE = "Select Download Folder";
    public String CHOOSE_PROMPT_BUTTON_TOOLTIP_TEXT = "I have selected my desired folder.";
    public String CHOOSE_PROMPT_BUTTON_TEXT = "DONE";
    public String PROMPT_EXIT_TITLE = "Exit?";
    public String PROMPT_EXIT_BODY = "Downloading has not yet finished. Are you sure you want to exit?";
    public String PROMPT_CLEAR_PERSONAL_TITLE = "Clear?";
    public String PROMPT_CLEAR_PERSONAL_BODY = "This will clear any personal settings (email, password, etc.) from this application. Proceed?";
    public String PROMPT_SERVER_UNRESPONSIVE_TITLE = "Keep waiting?";
    public String PROMPT_SERVER_UNRESPONSIVE_BODY = "The site is taking a long time to respond. Keep waiting?";
    public String PROMPT_DOWNLOAD_ERROR_TITLE = "Download Error";
    public String PROMPT_DOWNLOAD_ERROR_BODY = "There was an error while downloading this file.";
    public String PROMPT_OVERWRITE_TITLE = "Overwrite?";
    public String PROMPT_OVERWRITE_BODY = " already exists in your download folder. Overwrite?";
    public String PROMPT_OVERWRITE_CHECKBOX = "Apply to all remaining downloads.";
    public String PROMPT_NO_DOWNLOADS_TITLE = "No Downloads Available";
    public String PROMPT_NO_DOWNLOADS_BODY = "You have no downloads available at this time.";
    public String ERROR_INCORRECT_LOGIN = "Your login credentials are not correct.";
    public String ERROR_INCOMPLETE_LOGIN = "Please enter a valid email and password.";
    public String ERROR_SECURE_CONNECTION = "There was a problem establishing a secured connection with the server.";
    public String ERROR_CONNECTION = "There was a problem connecting to the server.";
    public String ERROR_DOWNLOADING_NOT_FINISHED = "Please wait until downloading has finished.";
    public String ERROR_ALREADY_ADDED_TO_LIBRARY = "Already added (or attempted to add) these downloads to your player.";
    public int APP_WIDTH = Integer.parseInt(this.prefs.get("APP_WIDTH", "750"));
    public int APP_HEIGHT = Integer.parseInt(this.prefs.get("APP_HEIGHT", "600"));
    public int APP_X = Integer.parseInt(this.prefs.get("APP_X", "1"));
    public int APP_Y = Integer.parseInt(this.prefs.get("APP_Y", "1"));
    public int TIMEOUT = 30000;
    public String SSL_HOST = "www.classicalarchives.com";
    public int SSL_PORT = 443;
    public String SSL_CACERTS_PASSWORD = "changeit";
    public String PAGE_CUSTOMER_SERVICE = "https://www.classicalarchives.com/secure/message.html?subject=general";
    public String PAGE_LOST_PASSWORD = "https://www.classicalarchives.com/secure/password.html";
    public String DOWNLOADS_URL = "https://www.classicalarchives.com/secure/downloads.html";
    public int DOWNLOADS_SIMULTANEOUS_MAX = 1;
    public String DOWNLOADS_TEMP_FOLDER = null;
    public String DOWNLOADS_FOLDER = this.prefs.get("DOWNLOADS_FOLDER", null);
    private String DOWNLOADS_DEFAULT_SUB_FOLDER = "Classical Archives Downloads";
    public String PLAYER_ITUNES = "iTunesJava.exe";
    public String PLAYER_WMP = "WMPJava.exe";
    public String PLAYLIST_NAME = "Classical Archives Downloads";
    public final String DOWNLOAD_ID = "dl_id";
    public final String DOWNLOAD_URL = "dl_url";
    public final String DOWNLOAD_DISPLAY_TITLE = "display_title";
    public final String DOWNLOAD_UBER_NODE = "downloads";
    public final String DOWNLOAD_TRACK_NODE = "download";
    public final String DOWNLOAD_COMMAND = "command";
    public final String HEADER_USERNAME = "X-EMAIL";
    public final String HEADER_PASSWORD = "X-PASSWORD";
    public final String HEADER_DOWNLOAD_STATUS = "X-DOWNLOAD-STATUS";
    public final String HEADER_DOWNLOAD_STATUS_COMPLETE = "complete";
    public final String HEADER_DOWNLOAD_ID = "X-DOWNLOAD-ID";

    public Constants() {
        if (this.DOWNLOADS_FOLDER == null) {
            ArrayList<String> default_folders = new ArrayList<String>();
            String user_home = System.getProperty("user.home");
            default_folders.add(user_home + File.separator + "Desktop" + File.separator);
            default_folders.add(user_home + File.separator + "My Documents" + File.separator + "My Music" + File.separator);
            default_folders.add(user_home + File.separator + "My Documents" + File.separator);
            default_folders.add(user_home + File.separator);
            for (int n = 0; n < default_folders.size(); ++n) {
                File default_folder = new File((String)default_folders.get(n));
                if (!default_folder.exists() || !default_folder.isDirectory()) continue;
                this.DOWNLOADS_FOLDER = default_folder.getPath() + File.separator + this.DOWNLOADS_DEFAULT_SUB_FOLDER;
                break;
            }
        }
        this.DOWNLOADS_TEMP_FOLDER = this.DOWNLOADS_FOLDER + File.separator + ".tmp";
    }
}

