/*
 * Decompiled with CFR 0.152.
 */
package com.prs.DownloadManager;

import com.prs.DownloadManager.Base64;
import com.prs.DownloadManager.Connection;
import com.prs.DownloadManager.DownloadManager;
import com.prs.DownloadManager.Preferences;
import com.prs.DownloadManager.Util;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Observable;
import org.w3c.dom.Element;

class Download
extends Observable
implements Runnable {
    public DownloadManager app;
    public Util util;
    public Preferences prefs;
    private String dl_folder;
    private String dl_temp_folder;
    private String dl_access_type;
    private String dl_id;
    private String dl_track_display_title;
    private String dl_filename;
    private String dl_checksum;
    private URL dl_url;
    private int dl_status;
    private int dl_size = -1;
    private int dl_downloaded;
    private final int MAX_BUFFER_SIZE = 1024;

    public Download(DownloadManager app, Element element) {
        try {
            this.app = app;
            this.util = new Util();
            this.prefs = new Preferences();
            this.init(element);
        }
        catch (Exception e) {
            this.error("Error in Download.Download(): " + e.getLocalizedMessage());
        }
    }

    public void init(Element element) throws Exception {
        this.setID(this.util.getElementValue(element, this.app.constants.DOWNLOAD_ID));
        this.setURL(new URL(this.util.getElementValue(element, this.app.constants.DOWNLOAD_URL)));
        this.setTrackDisplayTitle(this.util.getElementValue(element, this.app.constants.DOWNLOAD_DISPLAY_TITLE));
        this.setChecksum("");
        this.setSize(0);
        String _url = this.getURL().toString();
        this.setFilename(_url.substring(_url.lastIndexOf("/") + 1));
        this.setDownloaded(0);
        this.setStatus(this.app.constants.STATUS_PAUSED);
        this.setDownloadTempFolder(this.app.constants.DOWNLOADS_TEMP_FOLDER);
        this.setDownloadFolder(this.app.constants.DOWNLOADS_FOLDER);
    }

    public void clearDataRelatedToUnsupportedResumeAttempt() throws Exception {
        new File(this.getDownloadTempFolder() + File.separator + this.getFilename()).delete();
        this.setChecksum("");
        this.setSize(0);
        this.setDownloaded(0);
        this.util.writeToFile("info.log", "cleared temp data for " + this.getDownloadTempFolder() + File.separator + this.getFilename(), true);
    }

    private void download() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public int getDownloaded() {
        return this.dl_downloaded;
    }

    public void setDownloaded(int dl_downloaded) {
        this.dl_downloaded = dl_downloaded;
    }

    public String getAccessType() {
        return this.dl_access_type;
    }

    public void setAccessType(String dl_access_type) {
        this.dl_access_type = dl_access_type;
    }

    public String getID() {
        return this.dl_id;
    }

    public void setID(String dl_id) {
        this.dl_id = dl_id;
    }

    public int getSize() {
        return this.dl_size;
    }

    public void setSize(int dl_size) {
        this.dl_size = dl_size;
    }

    public float getProgress() {
        return (float)this.getDownloaded() / (float)this.getSize() * 100.0f;
    }

    public String getChecksum() {
        return this.dl_checksum;
    }

    public void setChecksum(String dl_checksum) {
        this.dl_checksum = dl_checksum;
    }

    private String getDownloadTempFolder() {
        return this.dl_temp_folder;
    }

    private void setDownloadTempFolder(String dl_temp_folder) {
        if (this.getStatus() == this.app.constants.STATUS_PAUSED && this.getDownloaded() == 0) {
            this.dl_temp_folder = dl_temp_folder;
        }
    }

    public String getDownloadFolder() {
        return this.dl_folder;
    }

    public void setDownloadFolder(String dl_folder) {
        if (this.getStatus() == this.app.constants.STATUS_PAUSED && this.getDownloaded() == 0) {
            this.dl_folder = dl_folder;
        }
    }

    public String getTrackDisplayTitle() {
        return this.dl_track_display_title;
    }

    public void setTrackDisplayTitle(String dl_track_display_title) {
        this.dl_track_display_title = dl_track_display_title;
    }

    public String getFilename() {
        return this.dl_filename;
    }

    public void setFilename(String dl_filename) {
        this.dl_filename = dl_filename;
    }

    public URL getURL() {
        return this.dl_url;
    }

    public void setURL(URL dl_url) {
        this.dl_url = dl_url;
    }

    public int getStatus() {
        return this.dl_status;
    }

    public void setStatus(int dl_status) {
        this.dl_status = dl_status;
    }

    public void pause() {
        if (this.getStatus() != this.app.constants.STATUS_COMPLETED && this.getStatus() != this.app.constants.STATUS_VERIFYING && this.getStatus() != this.app.constants.STATUS_MOVING && this.getStatus() != this.app.constants.STATUS_ERROR && this.getStatus() != this.app.constants.STATUS_CANCELLED) {
            this.setStatus(this.app.constants.STATUS_PAUSED);
            this.stateChanged();
        }
    }

    public void resume() {
        if (this.getStatus() == this.app.constants.STATUS_PAUSED) {
            this.setStatus(this.app.constants.STATUS_DOWNLOADING);
            this.stateChanged();
            this.download();
        }
    }

    public void cancel() {
        this.setStatus(this.app.constants.STATUS_CANCELLED);
        this.stateChanged();
    }

    public void completed() {
        this.setStatus(this.app.constants.STATUS_COMPLETED);
        this.stateChanged();
    }

    public void verifying() {
        this.setStatus(this.app.constants.STATUS_VERIFYING);
        this.stateChanged();
    }

    public void moving() {
        this.setStatus(this.app.constants.STATUS_MOVING);
        this.stateChanged();
    }

    public void clearFromServer() {
        try {
            HttpURLConnection con = new Connection(this.app).getConnection(this.app.constants.DOWNLOADS_URL);
            con.setRequestProperty(this.app.constants.HEADER_USERNAME, Base64.encode(this.app.member.getEmail()));
            con.setRequestProperty(this.app.constants.HEADER_PASSWORD, Base64.encode(this.app.member.getPassword()));
            con.setRequestProperty(this.app.constants.HEADER_DOWNLOAD_ID, Base64.encode(this.getID()));
            con.setRequestProperty(this.app.constants.HEADER_DOWNLOAD_STATUS, Base64.encode(this.app.constants.HEADER_DOWNLOAD_STATUS_COMPLETE));
            con.connect();
            if (con.getResponseCode() / 100 != 2) {
                throw new Exception("received " + con.getResponseCode() + " code for server, while attempting to clear completed download.");
            }
        }
        catch (Exception e) {
            this.util.writeToFile("info.log", "Error in Download.clearFromServer(): " + e.getLocalizedMessage(), true);
        }
    }

    private void error() {
        this.error(null);
    }

    private void error(String error_msg) {
        if (error_msg != null) {
            this.util.writeToFile("info.log", error_msg, true);
        }
        if (this.app.message.already_visible || !this.app.downloadRetriever.completed) {
            try {
                Thread.sleep(300L);
                return;
            }
            catch (InterruptedException e) {
                System.out.println("Interrupted Exception caught.");
            }
        } else {
            this.app.pauseAllDownloads();
            this.util.writeToFile("info.log", "Error downloading " + this.getFilename(), true);
            String[] custom_confirm_buttons = new String[]{"Retry", "Skip & Continue", "Cancel All"};
            int user_response = this.app.message.confirm(this.app, this.app.constants.PROMPT_DOWNLOAD_ERROR_BODY, this.app.constants.PROMPT_DOWNLOAD_ERROR_TITLE, null, custom_confirm_buttons);
            if (user_response == 0) {
                this.setSize(-1);
                this.setDownloaded(0);
                this.setStatus(this.app.constants.STATUS_PAUSED);
                this.app.refreshAllDownloads();
            } else if (user_response == 1) {
                this.setStatus(this.app.constants.STATUS_ERROR);
                this.stateChanged();
                this.app.resumeAllDownloads();
            } else if (user_response == -1) {
                this.app.cleanUpAndExit();
                this.error(error_msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        RandomAccessFile file = null;
        InputStream stream = null;
        try {
            byte[] buffer;
            int read;
            String content_md5;
            if (new File(this.getDownloadFolder() + File.separator + this.getFilename()).exists()) {
                boolean ok_to_overwrite = Boolean.parseBoolean(this.prefs.get("overwrite", null));
                if (!ok_to_overwrite) {
                    int user_response = this.app.message.confirm(this.app, this.getFilename() + this.app.constants.PROMPT_OVERWRITE_BODY, this.app.constants.PROMPT_OVERWRITE_TITLE, this.app.constants.PROMPT_OVERWRITE_CHECKBOX);
                    ok_to_overwrite = user_response == this.app.message.OPTION_YES;
                    this.prefs.put("overwrite", "" + (ok_to_overwrite && this.app.message.CHECKBOX_IS_CHECKED));
                }
                if (!ok_to_overwrite) {
                    this.util.writeToFile("info.log", "Cancelled " + this.getFilename(), true);
                    this.cancel();
                    return;
                }
            }
            this.util.writeToFile("info.log", "Downloading " + this.getFilename(), true);
            new File(this.getDownloadTempFolder()).mkdir();
            HttpURLConnection con = new Connection(this.app).getConnection(this.getURL());
            if (this.getDownloaded() > 0) {
                con.setRequestProperty("Range", "bytes=" + this.getDownloaded() + "-");
            }
            con.connect();
            if (con.getResponseCode() / 100 != 2) {
                throw new Exception("received " + con.getResponseCode() + " code for server, when connecting to " + this.getURL().toString());
            }
            if (con.getResponseCode() == 200 && this.getDownloaded() > 0) {
                this.clearDataRelatedToUnsupportedResumeAttempt();
            }
            this.util.writeToFile("info.log", "server response: " + con.getResponseCode(), true);
            if (this.getSize() < 1) {
                int content_length = con.getContentLength();
                if (content_length < 1) {
                    this.error("content length " + this.getSize() + " is not allowed");
                } else {
                    this.setSize(con.getContentLength());
                    this.stateChanged();
                }
            }
            if ((content_md5 = con.getHeaderField("Content-MD5")) != null && !content_md5.isEmpty()) {
                this.setChecksum(content_md5);
                this.stateChanged();
            }
            file = new RandomAccessFile(this.getDownloadTempFolder() + File.separator + this.getFilename(), "rw");
            file.seek(this.getDownloaded());
            stream = con.getInputStream();
            while (this.getStatus() == this.app.constants.STATUS_DOWNLOADING && (read = stream.read(buffer = this.getSize() - this.getDownloaded() > 1024 ? new byte[1024] : new byte[this.getSize() - this.getDownloaded()])) > 0) {
                file.write(buffer, 0, read);
                this.setDownloaded(this.getDownloaded() + read);
                this.stateChanged();
            }
            if (this.getStatus() != this.app.constants.STATUS_DOWNLOADING) return;
            file.close();
            stream.close();
            boolean file_verified = true;
            this.verifying();
            String actual_checksum = this.util.convertToMD5(this.getDownloadTempFolder() + File.separator + this.getFilename());
            file_verified = this.getChecksum().equals(actual_checksum);
            if (!file_verified) {
                throw new Exception("Checksum failed for " + this.getDownloadTempFolder() + File.separator + this.getFilename() + "(expected: " + this.getChecksum() + "; actual:" + actual_checksum + ")");
            }
            this.util.writeToFile("info.log", "Checksum verified for " + this.getFilename() + ": " + this.getChecksum() + " = " + actual_checksum, true);
            this.moving();
            if (!file_verified || !this.util.move(this.getFilename(), this.getDownloadTempFolder(), this.getDownloadFolder())) throw new Exception("Unable to move file: " + this.getDownloadTempFolder() + File.separator + this.getFilename() + " => " + this.getDownloadFolder());
            this.util.writeToFile("info.log", "Completed " + this.getFilename(), true);
            this.completed();
            this.clearFromServer();
        }
        catch (Exception e) {
            this.error("Error in Download.run(): " + e.getLocalizedMessage());
            return;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception exception) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
        return;
    }

    public void stateChanged() {
        this.setChanged();
        this.notifyObservers();
    }
}

