/*
 * Decompiled with CFR 0.152.
 */
package com.prs.DownloadManager;

import com.prs.DownloadManager.DownloadManager;
import java.io.File;
import javax.swing.JFileChooser;

public class DownloadFolderChooser
implements Runnable {
    private DownloadManager app = null;
    private boolean had_download_in_progress = false;

    public DownloadFolderChooser(DownloadManager app) {
        this.app = app;
    }

    @Override
    public void run() {
        try {
            this.had_download_in_progress = this.app.downloadTableModel.getActiveDownloadCount() != 0;
            this.app.pauseAllDownloads();
            this.app.setInfoLabel(this.app.constants.BUTTON_CHOOSE_DOWNLOADS_FOLDER);
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(1);
            chooser.setDialogTitle(this.app.constants.CHOOSE_PROMPT_TITLE);
            chooser.setApproveButtonToolTipText(this.app.constants.CHOOSE_PROMPT_BUTTON_TOOLTIP_TEXT);
            chooser.setApproveButtonText(this.app.constants.CHOOSE_PROMPT_BUTTON_TEXT);
            chooser.setSelectedFile(new File(this.app.constants.DOWNLOADS_FOLDER));
            if (chooser.showOpenDialog(this.app) == 0) {
                new File(this.app.constants.DOWNLOADS_FOLDER).mkdirs();
                this.app.prefs.put("DOWNLOADS_FOLDER", chooser.getSelectedFile().getPath());
                this.app.constants.DOWNLOADS_FOLDER = chooser.getSelectedFile().getPath();
                this.app.downloadTableModel.updateDownloadsFolder(this.app.constants.DOWNLOADS_FOLDER);
            }
            this.app.clearInfoLabel();
            this.app.setInfoLabel("Ready");
            if (this.had_download_in_progress) {
                this.app.resumeAllDownloads();
            }
        }
        catch (Exception e) {
            this.app.setInfoLabel(e.getMessage());
        }
    }
}

