/*
 * Decompiled with CFR 0.152.
 */
package com.prs.DownloadManager;

import com.prs.DownloadManager.CellRendererLabel;
import com.prs.DownloadManager.CellRendererProgress;
import com.prs.DownloadManager.Constants;
import com.prs.DownloadManager.Download;
import com.prs.DownloadManager.DownloadFolderChooser;
import com.prs.DownloadManager.DownloadRetriever;
import com.prs.DownloadManager.DownloadTableModel;
import com.prs.DownloadManager.LoginView;
import com.prs.DownloadManager.Member;
import com.prs.DownloadManager.MessageBox;
import com.prs.DownloadManager.NativePlayer;
import com.prs.DownloadManager.Preferences;
import com.prs.DownloadManager.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.table.TableColumn;
import org.w3c.dom.Element;

public class DownloadManager
extends JFrame {
    public Member member;
    public Constants constants;
    public Util util;
    public Preferences prefs;
    public NativePlayer native_player;
    public MessageBox message;
    public DownloadTableModel downloadTableModel;
    public Thread downloadRetrieverThread = null;
    public Thread downloadFolderThread = null;
    DownloadRetriever downloadRetriever = null;
    public Download userHighlightedDownload;
    public Desktop desktop = null;
    private Hashtable added_to_player_library = new Hashtable();
    private JButton WMPAddButton;
    private JMenuItem aboutItem;
    private JMenuItem changeDownloadFolderItem;
    private JMenuItem clearSettingsItem;
    private JMenuItem closeItem;
    private JMenuItem contactItem;
    private JButton downloadFolderButton;
    private JTable downloadTable;
    private JPanel downloadsPanel;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JButton iTunesAddButton;
    private JLabel infoLabel;
    private JMenuBar menuBar;
    private JScrollPane scrollPanel;
    private JButton startPauseDownloadButton;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            UIManager.put("ProgressBar.foreground", new Color(0, 160, 0));
            UIManager.put("ProgressBar.selectionBackground", Color.BLACK);
            UIManager.put("ProgressBar.selectionForeground", Color.BLACK);
        }
        catch (Exception e) {
            new Util().writeToFile("info.log", "Error in DownloadManager.main(): " + e.getMessage(), true);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DownloadManager();
            }
        });
    }

    public DownloadManager() {
        this.constants = new Constants();
        this.member = new Member(this);
        this.util = new Util();
        this.prefs = new Preferences();
        this.message = new MessageBox();
        this.prefs.remove("overwrite");
        this.util.writeToFile("info.log", "DownloadManager.DownloadManager(): Starting application (version: " + this.constants.APP_VERSION + ")...", true);
        if (Desktop.isDesktopSupported()) {
            this.desktop = Desktop.getDesktop();
        } else {
            this.contactItem.setEnabled(false);
        }
        this.initComponents();
        Enumeration<TableColumn> en = this.downloadTable.getColumnModel().getColumns();
        int col_int = -1;
        while (en.hasMoreElements()) {
            TableColumn col = en.nextElement();
            col.setPreferredWidth(this.downloadTableModel.column_widths[++col_int]);
        }
        this.setDefaultCloseOperation(0);
        this.setTitle(this.constants.APP_TITLE);
        try {
            Image app_icon = Toolkit.getDefaultToolkit().getImage(this.constants.APP_TITLE_ICON);
            this.setIconImage(app_icon);
        }
        catch (Exception e) {
            this.setTitle(e.getLocalizedMessage());
        }
        this.getContentPane().setBackground(this.constants.APP_BACKGROUND);
        this.setBounds(this.constants.APP_X, this.constants.APP_Y, this.constants.APP_WIDTH, this.constants.APP_HEIGHT);
        this.setMinimumSize(new Dimension(this.constants.APP_WIDTH, this.constants.APP_HEIGHT));
        this.center();
        this.startPauseDownloadButton.setEnabled(false);
        this.iTunesAddButton.setVisible(false);
        this.WMPAddButton.setVisible(false);
        this.setVisible(true);
        this.logIn();
        this.downloadRetriever = new DownloadRetriever(this);
        this.downloadRetrieverThread = new Thread(this.downloadRetriever);
        this.downloadRetrieverThread.start();
    }

    public void logIn() {
        new LoginView(this);
    }

    public void chooseDownloadDirectory() {
        if (this.downloadTableModel.downloading_has_commenced) {
            this.message.alert(this, "Unable to change the download folder after downloading has begun.\n\nYou may change it next time.", "Unable to change the download folder.");
        } else {
            this.downloadFolderThread = new Thread(new DownloadFolderChooser(this));
            this.downloadFolderThread.start();
        }
    }

    public void addDownload(Element element) {
        try {
            Download dl = this.downloadTableModel.getDownloadByID(this.util.getElementValue(element, this.constants.DOWNLOAD_ID));
            if (dl != null) {
                this.downloadTableModel.replaceDownload(dl, element);
            } else {
                this.downloadTableModel.addDownload(new Download(this, element));
            }
        }
        catch (Exception e) {
            this.util.writeToFile("info.log", "Error in DownloadManager.addDownload(): " + e.getMessage(), true);
        }
    }

    public void pauseAllDownloads() {
        try {
            this.downloadTableModel.pauseAllDownloads();
        }
        catch (Exception e) {
            this.util.writeToFile("info.log", "Error in DownloadManager.pauseAllDownloads(): " + e.getMessage(), true);
        }
    }

    public void resumeAllDownloads() {
        try {
            this.downloadTableModel.resumeAllDownloads(false);
        }
        catch (Exception e) {
            this.util.writeToFile("info.log", "Error in DownloadManager.resumeAllDownloads(): " + e.getMessage(), true);
        }
    }

    public void refreshAllDownloads() {
        this.pauseAllDownloads();
        this.downloadRetrieverThread = new Thread(new DownloadRetriever(this, true));
        this.downloadRetrieverThread.start();
    }

    private void addCompletedDownloadsToPlayer(String player) {
        try {
            if (this.downloadTableModel.getUnfinishedDownloadCount() > 0) {
                this.message.alert(this, this.constants.ERROR_DOWNLOADING_NOT_FINISHED, "Oops");
            } else if (this.isAddedToPlayerLibrary(player)) {
                this.message.alert(this, this.constants.ERROR_ALREADY_ADDED_TO_LIBRARY, "Oops");
            } else {
                ArrayList completed_downloads = this.downloadTableModel.getCompletedDownloads();
                Calendar cal = Calendar.getInstance();
                String playlist_name = this.constants.PLAYLIST_NAME + " (" + cal.get(1) + "-" + (cal.get(2) + 1) + "-" + cal.get(5) + ")";
                this.native_player = new NativePlayer(player);
                this.native_player.addFiles(playlist_name, completed_downloads);
                if (this.native_player.ignored_files == 0) {
                    this.message.alert(this, "Added " + this.native_player.added_files + " files to the player.", "Completed");
                } else if (this.native_player.ignored_files == completed_downloads.size()) {
                    this.message.alert(this, "Sorry. These files are incompatible with this player.", "Sorry");
                } else if (this.native_player.ignored_files > 0) {
                    this.message.alert(this, "Added " + this.native_player.added_files + " compatible files to the player.\nSkipped " + this.native_player.ignored_files + " incompatible files.", "Completed");
                }
            }
        }
        catch (Exception e) {
            this.util.writeToFile("info.log", "Error in DownloadManager.addCompletedDownloadsToPlayer(): " + e.getMessage(), true);
        }
    }

    public void openFolder(File path) {
        this.openFolder(path.getPath());
    }

    public void openFolder(String path) {
        try {
            File folder = new File(path);
            folder.mkdirs();
            if (System.getProperty("os.name").indexOf("Windows") != -1) {
                Runtime.getRuntime().exec("explorer.exe " + path);
            } else if (Desktop.isDesktopSupported()) {
                this.desktop.open(folder);
            }
        }
        catch (Exception e) {
            this.util.writeToFile("info.log", "Error in DownloadManager.openFolder(): " + e.getMessage(), true);
        }
    }

    public void openPage(URL page) {
        this.openPage(page.getPath());
    }

    public void openPage(String page) {
        try {
            if (Desktop.isDesktopSupported()) {
                this.desktop.browse(new URI(page));
            } else {
                this.util.writeToFile("info.log", "DownloadManager.openPage(): Desktop is not supported.", true);
            }
        }
        catch (Exception e) {
            this.util.writeToFile("info.log", "Error in DownloadManager.openPage(): " + e.getMessage(), true);
        }
    }

    public void center() {
        this.center(this);
    }

    public void center(Component component) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Point center = ge.getCenterPoint();
        int w = component.getWidth();
        int h = component.getHeight();
        int x = center.x - w / 2;
        int y = center.y - h / 2;
        component.setBounds(x, y, w, h);
        component.validate();
    }

    public void setInfoLabel(String val) {
        this.infoLabel.setText(val);
    }

    public String getInfoLabel() {
        return this.infoLabel.getText();
    }

    public void clearInfoLabel() {
        this.infoLabel.setText(" ");
    }

    public boolean isAddedToPlayerLibrary(String player) {
        return this.added_to_player_library.get(player) != null;
    }

    public void setAddedToPlayerLibrary(String player) {
        this.added_to_player_library.put(player, "");
    }

    public void downloadsCompleted() {
        this.startPauseDownloadButton.setText(this.constants.BUTTON_DOWNLOAD_COMPLETE);
        this.startPauseDownloadButton.setVisible(false);
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            this.setInfoLabel("<html>" + this.constants.MSG_DOWNLOADING_COMPLETE + "<br><br>" + this.constants.MSG_ADD_TO_YOUR_PLAYER_AFTER_DOWNLOADING_HAS_FINISHED + "<br><br>" + this.constants.MSG_ABOUT_DOWNLOADS_ON_YOUR_COMPUTER + "<br><br></html>");
            this.iTunesAddButton.setVisible(true);
            this.WMPAddButton.setVisible(true);
        } else {
            this.setInfoLabel("<html>" + this.constants.MSG_DOWNLOADING_COMPLETE + "</html>");
        }
    }

    public JButton getStartPauseDownloadButton() {
        return this.startPauseDownloadButton;
    }

    public void deleteFolder(File folder) {
        if (folder.isDirectory()) {
            String[] children = folder.list();
            for (int f = 0; f < children.length; ++f) {
                this.deleteFolder(new File(folder, children[f]));
            }
        }
        folder.delete();
    }

    public JTable getDownloadTable() {
        return this.downloadTable;
    }

    public void scrollToDownloadTableRow(int row_index) {
        this.getDownloadTable().setCellSelectionEnabled(true);
        this.getDownloadTable().changeSelection(row_index, 0, false, false);
        this.getDownloadTable().requestFocus();
    }

    public void cleanUpAndExit() {
        boolean ok_to_close = false;
        try {
            if (this.downloadTableModel.getUnfinishedDownloadCount() == 0) {
                ok_to_close = true;
            } else {
                int user_response = this.message.confirm(this, this.constants.PROMPT_EXIT_BODY, this.constants.PROMPT_EXIT_TITLE);
                if (user_response == this.message.OPTION_YES) {
                    ok_to_close = true;
                }
            }
            if (ok_to_close) {
                this.util.writeToFile("info.log", "Deleting temp folder: " + this.constants.DOWNLOADS_TEMP_FOLDER, true);
                this.deleteFolder(new File(this.constants.DOWNLOADS_TEMP_FOLDER));
            }
        }
        catch (Exception e) {
            this.util.writeToFile("info.log", "Error in DownloadManager.cleanUpAndExit(): " + e.getMessage(), true);
        }
        finally {
            if (ok_to_close) {
                try {
                    this.util.writeToFile("info.log", "Exiting application...", true);
                }
                catch (Exception exception) {}
                System.exit(0);
            }
        }
    }

    private void initComponents() {
        this.downloadsPanel = new JPanel();
        this.scrollPanel = new JScrollPane();
        this.downloadTableModel = new DownloadTableModel(this);
        this.downloadTable = new JTable();
        this.iTunesAddButton = new JButton();
        this.WMPAddButton = new JButton();
        this.infoLabel = new JLabel();
        this.startPauseDownloadButton = new JButton();
        this.downloadFolderButton = new JButton();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.changeDownloadFolderItem = new JMenuItem();
        this.clearSettingsItem = new JMenuItem();
        this.closeItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.contactItem = new JMenuItem();
        this.aboutItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DownloadManager.this.formWindowClosing(evt);
            }
        });
        this.downloadsPanel.setBorder(BorderFactory.createTitledBorder(this.constants.APP_DOWNLOADS_LABEL));
        this.downloadsPanel.setBackground(this.constants.APP_BACKGROUND);
        this.downloadTable.setSelectionMode(0);
        this.downloadTable.setBackground(Color.WHITE);
        this.downloadTable.setModel(this.downloadTableModel);
        CellRendererLabel stringCellRenderer = new CellRendererLabel();
        this.downloadTable.setDefaultRenderer(JLabel.class, stringCellRenderer);
        CellRendererProgress progressRenderer = new CellRendererProgress(0, 100);
        progressRenderer.setStringPainted(true);
        this.downloadTable.setDefaultRenderer(JProgressBar.class, progressRenderer);
        this.downloadTable.setRowHeight(45);
        this.downloadTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                DownloadManager.this.downloadTableMouseReleased(evt);
            }
        });
        this.downloadTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                DownloadManager.this.downloadTableMouseMoved(evt);
            }
        });
        this.scrollPanel.setViewportView(this.downloadTable);
        GroupLayout downloadsPanelLayout = new GroupLayout(this.downloadsPanel);
        this.downloadsPanel.setLayout(downloadsPanelLayout);
        downloadsPanelLayout.setHorizontalGroup(downloadsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(downloadsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.scrollPanel, -1, 645, Short.MAX_VALUE).addContainerGap()));
        downloadsPanelLayout.setVerticalGroup(downloadsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, downloadsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.scrollPanel, -1, 503, Short.MAX_VALUE).addContainerGap()));
        this.iTunesAddButton.setText("Add to iTunes");
        this.iTunesAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadManager.this.iTunesAddButtonActionPerformed(evt);
            }
        });
        this.WMPAddButton.setText("Add to WMP");
        this.WMPAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadManager.this.WMPAddButtonActionPerformed(evt);
            }
        });
        this.infoLabel.setBackground(this.constants.APP_BACKGROUND);
        this.infoLabel.setText(" ");
        this.infoLabel.setForeground(new Color(0, 60, 0));
        this.startPauseDownloadButton.setText(this.constants.BUTTON_DOWNLOAD_START);
        this.startPauseDownloadButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DownloadManager.this.startPauseDownloadButtonActionClicked(evt);
            }
        });
        this.downloadFolderButton.setText("OPEN DESTINATION FOLDER");
        this.downloadFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadManager.this.downloadFolderButtonActionPerformed(evt);
            }
        });
        this.menuBar.setBackground(this.constants.APP_BACKGROUND);
        this.fileMenu.setBackground(this.constants.APP_BACKGROUND);
        this.fileMenu.setText("File");
        this.changeDownloadFolderItem.setText("Change Download Folder");
        this.changeDownloadFolderItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadManager.this.changeDownloadFolderItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.changeDownloadFolderItem);
        this.clearSettingsItem.setText("Clear Personal Settings");
        this.clearSettingsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadManager.this.clearSettingsItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.clearSettingsItem);
        this.closeItem.setText("Exit");
        this.closeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadManager.this.closeItemActionPerformed(evt);
            }
        });
        this.closeItem.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DownloadManager.this.closeItemKeyPressed(evt);
            }
        });
        this.fileMenu.add(this.closeItem);
        this.menuBar.add(this.fileMenu);
        this.helpMenu.setText("Help");
        this.contactItem.setText("Get Help Online");
        this.contactItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadManager.this.contactItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.contactItem);
        this.aboutItem.setText("About");
        this.aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadManager.this.aboutItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.downloadsPanel, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.infoLabel, -2, 640, -2).addGroup(layout.createSequentialGroup().addComponent(this.startPauseDownloadButton, -2, 214, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downloadFolderButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.iTunesAddButton, -2, 107, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.WMPAddButton, -2, 108, -2))).addGap(14, 14, 14))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.infoLabel, -1, 21, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.startPauseDownloadButton, -2, 24, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.iTunesAddButton).addComponent(this.WMPAddButton, -2, 23, -2).addComponent(this.downloadFolderButton, -2, 23, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downloadsPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void closeItemActionPerformed(ActionEvent evt) {
        this.cleanUpAndExit();
    }

    private void closeItemKeyPressed(KeyEvent evt) {
        this.cleanUpAndExit();
    }

    private void iTunesAddButtonActionPerformed(ActionEvent evt) {
        this.addCompletedDownloadsToPlayer(this.constants.PLAYER_ITUNES);
    }

    private void WMPAddButtonActionPerformed(ActionEvent evt) {
        this.addCompletedDownloadsToPlayer(this.constants.PLAYER_WMP);
    }

    private void downloadTableMouseReleased(MouseEvent evt) {
        this.userHighlightedDownload = this.downloadTableModel.getDownload(this.getDownloadTable().getSelectedRow());
        this.getDownloadTable().clearSelection();
    }

    private void contactItemActionPerformed(ActionEvent evt) {
        this.openPage(this.constants.PAGE_CUSTOMER_SERVICE);
    }

    private void clearSettingsItemActionPerformed(ActionEvent evt) {
        int user_response = this.message.confirm(this, this.constants.PROMPT_CLEAR_PERSONAL_BODY, this.constants.PROMPT_CLEAR_PERSONAL_TITLE);
        if (user_response == this.message.OPTION_YES) {
            this.prefs.removeAll();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cleanUpAndExit();
    }

    private void downloadTableMouseMoved(MouseEvent evt) {
    }

    private void changeDownloadFolderItemActionPerformed(ActionEvent evt) {
        this.chooseDownloadDirectory();
    }

    private void downloadFolderButtonActionPerformed(ActionEvent evt) {
        this.openFolder(this.constants.DOWNLOADS_FOLDER);
    }

    private void aboutItemActionPerformed(ActionEvent evt) {
        this.message.alert(this, this.constants.APP_TITLE + " " + this.constants.APP_VERSION + "\n\n" + this.constants.APP_COPYRIGHT, "About");
    }

    private void startPauseDownloadButtonActionClicked(MouseEvent evt) {
        if (this.downloadTableModel.getActiveDownloadCount() != 0) {
            this.pauseAllDownloads();
            this.startPauseDownloadButton.setText(this.constants.BUTTON_DOWNLOAD_RESUME);
        } else {
            this.resumeAllDownloads();
            this.startPauseDownloadButton.setText(this.constants.BUTTON_DOWNLOAD_PAUSE);
        }
    }
}

