/*
 * Decompiled with CFR 0.152.
 */
package com.prs.DownloadManager;

import com.prs.DownloadManager.Download;
import com.prs.DownloadManager.DownloadManager;
import java.util.Timer;
import java.util.TimerTask;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DownloadRetriever
implements Runnable {
    private DownloadManager app;
    public boolean completed = false;
    public boolean refresh_mode = false;
    public Timer timeoutTimer = new Timer();
    public TimerTask timeoutTimerTask;

    public DownloadRetriever(DownloadManager app, boolean refresh_mode) {
        this.app = app;
        this.refresh_mode = refresh_mode;
    }

    public DownloadRetriever(DownloadManager app) {
        this.app = app;
    }

    @Override
    public void run() {
        block14: {
            try {
                if (this.completed) break block14;
                this.timeoutTimerTask = new TimerTask(){

                    @Override
                    public void run() {
                        int user_response;
                        if (!DownloadRetriever.this.completed && (user_response = ((DownloadRetriever)DownloadRetriever.this).app.message.confirm(DownloadRetriever.this.app, ((DownloadRetriever)DownloadRetriever.this).app.constants.PROMPT_SERVER_UNRESPONSIVE_BODY, ((DownloadRetriever)DownloadRetriever.this).app.constants.PROMPT_SERVER_UNRESPONSIVE_TITLE)) != ((DownloadRetriever)DownloadRetriever.this).app.message.OPTION_YES) {
                            DownloadRetriever.this.app.cleanUpAndExit();
                        }
                    }
                };
                this.timeoutTimer.schedule(this.timeoutTimerTask, this.app.constants.TIMEOUT);
                this.app.setInfoLabel("Obtaining available downloads...");
                this.app.util.writeToFile("info.log", "DownloadRetriever.run(): Obtaining available downloads...", true);
                Document doc = this.app.util.getXMLDocument(this.app.constants.DOWNLOADS_URL, this.app);
                this.timeoutTimerTask.cancel();
                if (doc == null) {
                    throw new Exception("app.util.getXMLDocument(\"" + this.app.constants.DOWNLOADS_URL + "\", app) was unable to retrieve the XML from the server.");
                }
                boolean ok_to_continue = false;
                NodeList command_list = doc.getElementsByTagName("command");
                for (int n = 0; n < command_list.getLength(); ++n) {
                    Node node = command_list.item(n);
                    String command = node.getChildNodes().item(0).getNodeValue();
                    if (command == null) continue;
                    if (command.indexOf("login") == 0) {
                        this.app.logIn();
                        this.run();
                        continue;
                    }
                    if (command.indexOf("alert") == 0) {
                        this.app.message.alert(this.app, command.split(":::")[1]);
                        continue;
                    }
                    if (command.indexOf("page") == 0) {
                        this.app.openPage(command.split(":::")[1]);
                        continue;
                    }
                    if (command.indexOf("exit") == 0) {
                        this.app.cleanUpAndExit();
                        continue;
                    }
                    if (command.indexOf("continue") != 0) continue;
                    ok_to_continue = true;
                }
                NodeList download_list = doc.getElementsByTagName(this.app.constants.DOWNLOAD_TRACK_NODE);
                if (!ok_to_continue) break block14;
                if (download_list != null) {
                    for (int n = 0; n < download_list.getLength(); ++n) {
                        Node node = download_list.item(n);
                        if (node.getNodeType() != 1) continue;
                        if (this.refresh_mode) {
                            Download dl = this.app.downloadTableModel.getDownloadByID(this.app.util.getElementValue((Element)node, this.app.constants.DOWNLOAD_ID));
                            if (dl.getStatus() != this.app.constants.STATUS_PAUSED) continue;
                            dl.init((Element)node);
                            continue;
                        }
                        this.app.addDownload((Element)node);
                    }
                    if (download_list.getLength() == 0) {
                        this.app.getStartPauseDownloadButton().setEnabled(false);
                        this.app.getStartPauseDownloadButton().setVisible(false);
                        this.app.setInfoLabel("");
                        this.app.message.alert(this.app, this.app.constants.PROMPT_NO_DOWNLOADS_BODY, this.app.constants.PROMPT_NO_DOWNLOADS_TITLE);
                    } else {
                        this.app.getStartPauseDownloadButton().setEnabled(true);
                        this.app.getStartPauseDownloadButton().setVisible(true);
                        this.app.clearInfoLabel();
                        if (this.refresh_mode) {
                            this.app.resumeAllDownloads();
                        }
                        this.completed = true;
                    }
                    break block14;
                }
                throw new Exception("No xml was returned.");
            }
            catch (Exception e) {
                this.app.message.alert(this.app, "An unexpected error was encountered:\n" + e.getMessage(), "Error");
                this.app.util.writeToFile("info.log", "Error in DownloadRetriever.run(): " + e.getMessage(), true);
                this.completed = true;
                this.app.cleanUpAndExit();
            }
        }
    }
}

