/*
 * Decompiled with CFR 0.152.
 */
package com.prs.DownloadManager;

import com.prs.DownloadManager.Constants;
import com.prs.DownloadManager.Download;
import com.prs.DownloadManager.DownloadManager;
import com.prs.DownloadManager.Util;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.table.AbstractTableModel;
import org.w3c.dom.Element;

class DownloadTableModel
extends AbstractTableModel
implements Observer {
    public Constants constants;
    public Util util;
    public DownloadManager app;
    private boolean paused = true;
    public boolean downloading_has_commenced = false;
    private ArrayList downloadArrayList = new ArrayList();
    public final String[] column_names = new String[]{"Title", "Size", "Total", "Status"};
    public final Class[] column_classes = new Class[]{JLabel.class, String.class, JProgressBar.class, String.class};
    public final int[] column_widths = new int[]{600, 70, 115, 100};

    public DownloadTableModel(DownloadManager app) {
        this.app = app;
        this.constants = new Constants();
        this.util = new Util();
    }

    @Override
    public void update(Observable o, Object arg) {
        int row_index = this.downloadArrayList.indexOf(o);
        this.fireTableRowsUpdated(row_index, row_index);
        this.app.scrollToDownloadTableRow(row_index);
        if (this.getUnfinishedDownloadCount() == 0) {
            this.app.downloadsCompleted();
        } else {
            this.resumeAllDownloads();
        }
    }

    public void addDownload(Download download) {
        try {
            download.addObserver(this);
            this.downloadArrayList.add(download);
            this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
        }
        catch (Exception e) {
            this.util.writeToFile("info.log", "Error in DownloadTableModel.addDownload(): " + e.getMessage(), true);
        }
    }

    public void replaceDownload(Download existing_download, Element element) {
        try {
            for (int n = 0; n < this.downloadArrayList.size(); ++n) {
                Download dl = (Download)this.downloadArrayList.get(n);
                if (dl != existing_download) continue;
                existing_download.init(element);
                return;
            }
        }
        catch (Exception e) {
            this.util.writeToFile("info.log", "Error in DownloadTableModel.replaceDownload(): " + e.getMessage(), true);
        }
    }

    public void pauseAllDownloads() {
        if (this.getUnfinishedDownloadCount() == 0) {
            return;
        }
        this.paused = true;
        for (int n = 0; n < this.downloadArrayList.size(); ++n) {
            ((Download)this.downloadArrayList.get(n)).pause();
        }
        this.app.setInfoLabel("<html>Paused..." + (System.getProperty("os.name").indexOf("Windows") != -1 ? "<br>" + this.constants.MSG_ADD_TO_YOUR_PLAYER_BEFORE_DOWNLOADING_HAS_FINISHED : "") + "</html>");
    }

    public void resumeAllDownloads(boolean pause) {
        this.paused = pause;
        this.downloading_has_commenced = true;
        this.resumeAllDownloads();
    }

    public void resumeAllDownloads() {
        if (this.getUnfinishedDownloadCount() == 0) {
            return;
        }
        if (!this.paused && this.getActiveDownloadCount() < this.constants.DOWNLOADS_SIMULTANEOUS_MAX) {
            for (int n = 0; n < this.downloadArrayList.size() && this.getActiveDownloadCount() < this.constants.DOWNLOADS_SIMULTANEOUS_MAX; ++n) {
                ((Download)this.downloadArrayList.get(n)).resume();
            }
        }
        if (this.getActiveDownloadCount() > 0) {
            this.app.setInfoLabel("<html>Downloading..." + (System.getProperty("os.name").indexOf("Windows") != -1 ? "<br>" + this.constants.MSG_ADD_TO_YOUR_PLAYER_BEFORE_DOWNLOADING_HAS_FINISHED : "") + "</html>");
        }
    }

    public ArrayList getCompletedDownloads() {
        this.pauseAllDownloads();
        ArrayList<Download> files = new ArrayList<Download>();
        for (int n = 0; n < this.downloadArrayList.size(); ++n) {
            Download file = (Download)this.downloadArrayList.get(n);
            if (file.getStatus() != this.constants.STATUS_COMPLETED) continue;
            files.add(file);
        }
        return files;
    }

    public void updateDownloadsFolder(String downloads_folder) {
        this.pauseAllDownloads();
        for (int n = 0; n < this.downloadArrayList.size(); ++n) {
            ((Download)this.downloadArrayList.get(n)).setDownloadFolder(downloads_folder);
        }
    }

    public Download getDownload(int row) {
        return (Download)this.downloadArrayList.get(row);
    }

    public Download getDownloadByID(String download_id) {
        for (int n = 0; n < this.downloadArrayList.size(); ++n) {
            Download dl = (Download)this.downloadArrayList.get(n);
            if (!dl.getID().equals(download_id)) continue;
            return dl;
        }
        return null;
    }

    public void clearDownload(int row) {
        this.downloadArrayList.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    @Override
    public int getRowCount() {
        return this.downloadArrayList.size();
    }

    @Override
    public int getColumnCount() {
        return this.column_names.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.column_names[col];
    }

    public Class getColumnClass(int col) {
        return this.column_classes[col];
    }

    public int getActiveDownloadCount() {
        int count = 0;
        int status = -1;
        for (int n = 0; n < this.downloadArrayList.size(); ++n) {
            status = ((Download)this.downloadArrayList.get(n)).getStatus();
            if (status != this.constants.STATUS_DOWNLOADING && status != this.constants.STATUS_VERIFYING && status != this.constants.STATUS_MOVING) continue;
            ++count;
        }
        return count;
    }

    public int getUnfinishedDownloadCount() {
        int count = 0;
        int status = -1;
        for (int n = 0; n < this.downloadArrayList.size(); ++n) {
            status = ((Download)this.downloadArrayList.get(n)).getStatus();
            if (status != this.constants.STATUS_PAUSED && status != this.constants.STATUS_DOWNLOADING && status != this.constants.STATUS_VERIFYING && status != this.constants.STATUS_MOVING) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Download download = (Download)this.downloadArrayList.get(row);
        switch (col) {
            case 0: {
                return download.getTrackDisplayTitle() + "<br/><b>" + download.getFilename() + "</b>";
            }
            case 1: {
                float f;
                float size = download.getSize();
                String size_str = "";
                size /= 1024.0f;
                if (f < 1024.0f) {
                    size_str = this.util.roundToDecimalPlaces(size, 0) + " KB";
                } else {
                    float f2;
                    size /= 1024.0f;
                    if (f2 < 1024.0f) {
                        size_str = this.util.roundToDecimalPlaces(size, 1) + " MB";
                    }
                }
                return size > 0.0f ? size_str : "";
            }
            case 2: {
                return new Float(download.getProgress());
            }
            case 3: {
                return Constants.STATUSES[download.getStatus()];
            }
        }
        return "";
    }
}

