/*
 * Decompiled with CFR 0.152.
 */
package com.prs.DownloadManager;

import com.prs.DownloadManager.Constants;
import com.prs.DownloadManager.DownloadManager;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class LoginView
extends JDialog {
    public Constants constants = new Constants();
    public DownloadManager app;
    private JTextField emailField;
    private JLabel emailLabel;
    private JButton forgotPasswordButton;
    private JButton loginButton;
    private JLabel messageLabel;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JCheckBox rememberMeCheckbox;

    public LoginView(DownloadManager app) {
        this.initComponents();
        this.app = app;
        this.getContentPane().setBackground(this.constants.APP_BACKGROUND);
        this.setModal(true);
        app.member.setLoggedIn(false);
        if (app.member.getEmail() != null && app.member.getPassword() != null) {
            this.emailField.setText(app.member.getEmail());
            this.passwordField.setText(app.member.getPassword());
            this.rememberMeCheckbox.setSelected(app.member.isRememberMe());
        }
        app.setInfoLabel("Logging in...");
        app.center(this);
        this.app.getToolkit();
        Image app_icon = Toolkit.getDefaultToolkit().getImage(this.constants.APP_TITLE_ICON);
        this.setIconImage(app_icon);
        this.setTitle("Please log in to Classical Archives.");
        this.setVisible(true);
    }

    public void login() {
        if (!this.app.member.isValidInput(this.emailField.getText(), this.passwordField.getPassword())) {
            this.messageLabel.setText(this.constants.ERROR_INCOMPLETE_LOGIN);
        } else {
            if (!this.rememberMeCheckbox.isSelected()) {
                this.app.member.removeLogin();
            }
            this.app.member.login(this.emailField.getText(), this.passwordField.getPassword(), this.rememberMeCheckbox.isSelected());
            if (this.app.member.isLoggedIn()) {
                this.app.util.writeToFile("info.log", "LoginView.login(): User login successful.", true);
                this.messageLabel.setText(this.constants.MSG_LOGIN);
                this.setVisible(false);
            } else {
                this.app.util.writeToFile("info.log", "LoginView.login(): User login failed.", true);
                this.messageLabel.setText(this.constants.ERROR_INCORRECT_LOGIN);
            }
        }
    }

    private void initComponents() {
        this.passwordLabel = new JLabel();
        this.emailLabel = new JLabel();
        this.passwordField = new JPasswordField();
        this.emailField = new JTextField();
        this.loginButton = new JButton();
        this.messageLabel = new JLabel();
        this.rememberMeCheckbox = new JCheckBox();
        this.forgotPasswordButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                LoginView.this.ExitIfNotLoggedIn(evt);
            }
        });
        this.passwordLabel.setText("Password");
        this.emailLabel.setText("Email");
        this.passwordField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                LoginView.this.passwordFieldFocusGained(evt);
            }
        });
        this.passwordField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                LoginView.this.passwordFieldKeyReleased(evt);
            }
        });
        this.emailField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                LoginView.this.emailFieldFocusGained(evt);
            }
        });
        this.emailField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                LoginView.this.emailFieldKeyReleased(evt);
            }
        });
        this.loginButton.setText("LOG IN");
        this.loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginView.this.loginButtonActionPerformed(evt);
            }
        });
        this.messageLabel.setText(this.constants.MSG_LOGIN);
        this.rememberMeCheckbox.setBackground(this.constants.APP_BACKGROUND);
        this.rememberMeCheckbox.setText("Remember Me");
        this.rememberMeCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginView.this.rememberMeCheckboxActionPerformed(evt);
            }
        });
        this.forgotPasswordButton.setText("Forgot My Login");
        this.forgotPasswordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginView.this.forgotPasswordButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.messageLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.passwordLabel).addComponent(this.emailLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.loginButton, -2, 152, -2).addGap(6, 6, 6).addComponent(this.rememberMeCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.forgotPasswordButton)).addComponent(this.passwordField).addComponent(this.emailField, -2, 428, -2)))).addGap(18, 18, 18)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.messageLabel, -2, 14, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.emailLabel).addComponent(this.emailField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordLabel).addComponent(this.passwordField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loginButton).addComponent(this.rememberMeCheckbox).addComponent(this.forgotPasswordButton)).addContainerGap(19, Short.MAX_VALUE)));
        this.pack();
    }

    private void loginButtonActionPerformed(ActionEvent evt) {
        this.login();
    }

    private void rememberMeCheckboxActionPerformed(ActionEvent evt) {
    }

    private void emailFieldKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.login();
        }
    }

    private void emailFieldFocusGained(FocusEvent evt) {
        this.emailField.selectAll();
    }

    private void passwordFieldFocusGained(FocusEvent evt) {
        this.passwordField.selectAll();
    }

    private void forgotPasswordButtonActionPerformed(ActionEvent evt) {
        try {
            this.app.openPage(this.constants.PAGE_LOST_PASSWORD);
            this.app.cleanUpAndExit();
        }
        catch (Exception e) {
            this.setTitle("Please contact us to retrieve your login info.");
        }
    }

    private void passwordFieldKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.login();
        }
    }

    private void ExitIfNotLoggedIn(WindowEvent evt) {
        if (!this.app.member.isLoggedIn()) {
            this.app.cleanUpAndExit();
        }
    }
}

