/*
 * Decompiled with CFR 0.152.
 */
package com.prs.DownloadManager;

import com.prs.DownloadManager.DownloadManager;
import com.prs.DownloadManager.Preferences;

public class Member {
    private DownloadManager app;
    private Preferences prefs;
    private boolean m_logged_in = false;
    private String m_email = null;
    private String m_password = null;
    private boolean m_remember_me = false;

    public Member(DownloadManager app) {
        this.app = app;
        this.prefs = new Preferences();
        this.m_email = this.prefs.get("email", null);
        this.m_password = this.prefs.get("password", null);
        this.m_remember_me = Boolean.parseBoolean(this.prefs.get("remember_me", null));
    }

    public boolean login(String email, char[] password, boolean remember) {
        String password_str = "";
        for (int n = 0; n < password.length; ++n) {
            password_str = password_str + password[n];
        }
        if (remember) {
            this.prefs.put("email", email);
            this.prefs.put("password", password_str);
            this.prefs.put("remember_me", Boolean.valueOf(remember).toString());
        } else {
            this.prefs.remove("email");
            this.prefs.remove("password");
            this.prefs.remove("remember_me");
        }
        this.setEmail(email);
        this.setPassword(password_str);
        this.setRememberMe(remember);
        this.setLoggedIn(true);
        return this.isLoggedIn();
    }

    public boolean isValidInput(String email, char[] password) {
        return email != null && email.indexOf("@") > 0 && email.trim().length() > 4 && password != null && password.length > 0;
    }

    public String getEmail() {
        return this.m_email;
    }

    public void setEmail(String email) {
        this.m_email = email;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public boolean isRememberMe() {
        return this.m_remember_me;
    }

    public void setRememberMe(boolean remember_me) {
        this.m_remember_me = remember_me;
    }

    public boolean isLoggedIn() {
        return this.m_logged_in;
    }

    public void setLoggedIn(boolean logged_in) {
        this.m_logged_in = logged_in;
    }

    public void removeLogin() {
        try {
            this.prefs.remove("email");
            this.prefs.remove("password");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

