/*
 * Decompiled with CFR 0.152.
 */
package com.prs.DownloadManager;

import com.prs.DownloadManager.Constants;
import com.prs.DownloadManager.Download;
import com.prs.DownloadManager.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class NativePlayer {
    public Util util;
    public Constants constants;
    public String player;
    public int added_files = 0;
    public int ignored_files = 0;

    public NativePlayer(String player) {
        this.player = player;
        this.util = new Util();
        this.constants = new Constants();
    }

    public String addFiles(String playlist_filename, ArrayList<Download> filenames) {
        try {
            String filenames_string = "";
            for (int n = 0; n < filenames.size(); ++n) {
                Download file = filenames.get(n);
                if (this.player.equals(this.constants.PLAYER_ITUNES) && file.getFilename().toLowerCase().indexOf(".mp3") == -1) {
                    ++this.ignored_files;
                    continue;
                }
                ++this.added_files;
                filenames_string = filenames_string + " \"" + file.getDownloadFolder() + File.separator + file.getFilename() + "\"";
            }
            if (this.added_files > 0) {
                return this.addFiles(playlist_filename, filenames_string);
            }
            return "No compatible files available to add.";
        }
        catch (Exception e) {
            this.util.writeToFile("info.log", "Error in NativePlayer.addFiles(): " + e.getMessage(), true);
            return e.getMessage();
        }
    }

    public String addFiles(String playlist_filename, String filenames) {
        try {
            String line;
            if (filenames.length() == 0) {
                throw new Exception("Error: No filenames were passed. Did not add any files to the player.");
            }
            if (!filenames.endsWith("\"")) {
                throw new Exception("Error: Filenames were not in quotes. Did not add any files to the player.");
            }
            playlist_filename = "\"" + playlist_filename.replaceAll("\"", "").trim() + "\"";
            String command = this.player + " " + playlist_filename + filenames;
            this.util.writeToFile("info.log", "adding files to player: " + command, true);
            Process p = Runtime.getRuntime().exec(command);
            StringBuffer program_response = new StringBuffer();
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                program_response.append(line + "\n");
            }
            input.close();
            p.destroy();
            this.util.writeToFile("info.log", "NativePlayer.addFiles(): " + program_response.toString(), true);
            return program_response.toString();
        }
        catch (Exception e) {
            this.util.writeToFile("info.log", "Error in NativePlayer.addFiles(): " + e.getMessage(), true);
            return e.getMessage();
        }
    }
}

