/*
 * Decompiled with CFR 0.152.
 */
package com.prs.DownloadManager;

import com.prs.DownloadManager.Constants;
import com.prs.DownloadManager.Util;
import java.io.File;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSL {
    public Constants constants;
    public Util util;
    private char SEP = File.separatorChar;
    private String cacerts_folder = System.getProperty("java.home") + this.SEP + "lib" + this.SEP + "security";
    private String cacerts_filename = "cacerts";
    private final char[] HEXDIGITS = "0123456789abcdef".toCharArray();

    public SSL() {
        this.constants = new Constants();
        this.util = new Util();
    }

    public boolean validateCertificate() {
        return this.validateCertificate(this.constants.SSL_HOST, this.constants.SSL_PORT, this.constants.SSL_CACERTS_PASSWORD);
    }

    public boolean validateCertificate(String host, int port, String password) {
        try {
            char SEP = File.separatorChar;
            boolean useCustomKS = true;
            KeyStore ks = null;
            if (useCustomKS) {
                InputStream in = this.getClass().getResourceAsStream("/certs/cma_jssecacerts.jks");
                ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(in, password.toCharArray());
                in.close();
            }
            SSLContext context = SSLContext.getInstance("TLS");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            if (useCustomKS) {
                tmf.init(ks);
            } else {
                tmf.init((KeyStore)null);
            }
            X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
            SavingTrustManager tm = new SavingTrustManager(defaultTrustManager);
            context.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory factory = context.getSocketFactory();
            SSLSocket socket = (SSLSocket)factory.createSocket(host, port);
            socket.setSoTimeout(10000);
            try {
                socket.startHandshake();
                socket.close();
                return true;
            }
            catch (SSLException sSLException) {
                X509Certificate cert;
                X509Certificate[] chain = tm.chain;
                if (chain == null) {
                    this.util.writeToFile("info.log", "Could not obtain server certificate chain", true);
                    return false;
                }
                MessageDigest sha1 = MessageDigest.getInstance("SHA1");
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                for (int i = 0; i < chain.length; ++i) {
                    cert = chain[i];
                    sha1.update(cert.getEncoded());
                    md5.update(cert.getEncoded());
                }
                int choice = 0;
                cert = chain[choice];
                String alias = host + "-" + (choice + 1);
                return true;
            }
        }
        catch (Exception e) {
            this.util.writeToFile("info.log", "Error in SSL.validateCertificate(): " + e.getMessage(), true);
            return false;
        }
    }

    private String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (int n : bytes) {
            sb.append(this.HEXDIGITS[(n &= 0xFF) >> 4]);
            sb.append(this.HEXDIGITS[n & 0xF]);
            sb.append(' ');
        }
        return sb.toString();
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.getSSLSocketFactory(this.constants.SSL_HOST, this.constants.SSL_PORT, this.constants.SSL_CACERTS_PASSWORD);
    }

    public SSLSocketFactory getSSLSocketFactory(String host, int port, String password) {
        try {
            boolean useCustomKS = true;
            KeyStore ks = null;
            if (useCustomKS) {
                InputStream in = this.getClass().getResourceAsStream("/certs/cma_jssecacerts.jks");
                ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(in, password.toCharArray());
                in.close();
            }
            SSLContext context = SSLContext.getInstance("TLS");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            if (useCustomKS) {
                tmf.init(ks);
            } else {
                tmf.init((KeyStore)null);
            }
            X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
            SavingTrustManager tm = new SavingTrustManager(defaultTrustManager);
            context.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory factory = context.getSocketFactory();
            return factory;
        }
        catch (Exception e) {
            this.util.writeToFile("info.log", "Error in SSL.getSSLSocketFactory(): " + e.getMessage(), true);
            return null;
        }
    }

    private class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new UnsupportedOperationException("checkClientTrusted not implemented");
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
            this.tm.checkServerTrusted(chain, authType);
        }
    }
}

