/*
 * Decompiled with CFR 0.152.
 */
package com.prs.DownloadManager;

import com.prs.DownloadManager.Base64;
import com.prs.DownloadManager.Connection;
import com.prs.DownloadManager.Constants;
import com.prs.DownloadManager.DownloadManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Util {
    public Constants constants = new Constants();
    private int log_count = 0;
    private int log_count_max = 20000;

    public boolean writeToFile(String filename, String text, boolean addTimeStamp) {
        ArrayList<String> _text = new ArrayList<String>();
        _text.add(text);
        return this.writeToFile(filename, _text, addTimeStamp);
    }

    public boolean writeToFile(String filename, StackTraceElement[] element, boolean addTimeStamp) {
        ArrayList<String> _text = new ArrayList<String>();
        for (int x = 0; x < element.length; ++x) {
            _text.add(element[x].toString());
        }
        return this.writeToFile(filename, _text, addTimeStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeToFile(String filename, ArrayList text, boolean addTimeStamp) {
        if (this.log_count == this.log_count_max) {
            text.clear();
            text.add("Util.writeToFile(): Error: Reached limit of " + this.log_count_max + " log entries. Unable to add any more logs.");
        } else if (this.log_count > this.log_count_max) {
            return false;
        }
        ++this.log_count;
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        String path_to_logs = this.constants.DOWNLOADS_FOLDER + File.separator + "logs" + File.separator + year + "-" + (month < 10 ? "0" : "") + month + "-" + (day < 10 ? "0" : "") + day;
        new File(path_to_logs).mkdirs();
        String time = "[" + cal.getTime() + "]";
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(path_to_logs + File.separator + filename), true), "UTF8"));
            for (int n = 0; n < text.size(); ++n) {
                bw.write((addTimeStamp ? time + " " : "") + (String)text.get(n));
                bw.newLine();
            }
            bw.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                    return true;
                }
                catch (Exception exception) {}
            }
            return false;
        }
    }

    public Document getXMLDocument(String url, DownloadManager app) {
        try {
            HttpURLConnection con = new Connection(app).getConnection(new URL(url));
            con.setRequestProperty(app.constants.HEADER_USERNAME, Base64.encode(app.member.getEmail()));
            con.setRequestProperty(app.constants.HEADER_PASSWORD, Base64.encode(app.member.getPassword()));
            return this.getXMLDocument(con);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String stack_trace = sw.toString();
            this.writeToFile("info.log", "Error in Util.getXMLDocument(url,app): " + e.getMessage() + "\r\nstack trace:\r\n" + stack_trace, true);
            return null;
        }
    }

    public Document getXMLDocument(HttpURLConnection con) {
        try {
            DocumentBuilder doc_builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = doc_builder.parse(con.getInputStream());
            return doc;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String stack_trace = sw.toString();
            this.writeToFile("info.log", "Error in Util.getXMLDocument(con): " + e.getMessage() + "\r\nstack trace:\r\n" + stack_trace, true);
            return null;
        }
    }

    public NodeList getElementsByTagName(String xml_file, String xml_name) {
        try {
            DocumentBuilder doc_builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = doc_builder.parse(xml_file);
            NodeList nlist = doc.getElementsByTagName(xml_name);
            return nlist;
        }
        catch (Exception e) {
            this.writeToFile("info.log", "Error in Util.getElementsByTagName(): " + e.getMessage(), true);
            return null;
        }
    }

    public NodeList getElementsByTagName(HttpURLConnection con, String xml_name) {
        try {
            DocumentBuilder doc_builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = doc_builder.parse(con.getInputStream());
            NodeList nlist = doc.getElementsByTagName(xml_name);
            return nlist;
        }
        catch (Exception e) {
            this.writeToFile("info.log", "Error in Util.getElementsByTagName(): " + e.getMessage(), true);
            return null;
        }
    }

    public String getElementValue(Element element, String element_name) {
        try {
            NodeList nodeList = element.getElementsByTagName(element_name);
            Element childElement = (Element)nodeList.item(0);
            NodeList childNodeList = childElement.getChildNodes();
            return childNodeList.item(0).getNodeValue().trim();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String roundToDecimalPlaces(double doubleNumber, int decimal_places) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(decimal_places);
        nf.setMinimumFractionDigits(decimal_places);
        nf.setMaximumIntegerDigits(10);
        nf.setMinimumIntegerDigits(1);
        nf.setGroupingUsed(true);
        return nf.format(doubleNumber);
    }

    public String roundToDecimalPlaces(String floatNumber, int decimal_places) {
        return this.roundToDecimalPlaces(Float.parseFloat(floatNumber), decimal_places);
    }

    public String roundToDecimalPlaces(float floatNumber, int decimal_places) {
        return this.roundToDecimalPlaces((double)floatNumber, decimal_places);
    }

    public boolean move(String filename, String source_folder, String destination_folder) {
        try {
            File source_file = new File(source_folder + File.separator + filename);
            new File(destination_folder).mkdir();
            File moved_file = new File(destination_folder + File.separator + filename);
            moved_file.delete();
            this.writeToFile("info.log", "Moving: " + source_file + " => " + moved_file, true);
            return source_file.renameTo(moved_file);
        }
        catch (Exception e) {
            this.writeToFile("info.log", "Error in Util.move(): " + e.getMessage(), true);
            return false;
        }
    }

    public String convertToMD5(String file) {
        return this.convertToMD5(new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertToMD5(File file) {
        InputStream input = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            input = new FileInputStream(file);
            byte[] buffer = new byte[8192];
            int read = 0;
            while ((read = input.read(buffer)) > 0) {
                md.update(buffer, 0, read);
            }
            byte[] md5sum = md.digest();
            String string = new String(Base64.encode(md5sum));
            return string;
        }
        catch (Exception e) {
            this.writeToFile("info.log", "Error in Util.convertToMD5(): " + e.getMessage(), true);
            String string = null;
            return string;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception e) {
                this.writeToFile("info.log", "Error in Util.convertToMD5(): " + e.getMessage(), true);
            }
        }
    }
}

